/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.loading;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PersonImportance;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMission;
import com.fs.starfarer.api.util.Misc;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class PersonMissionSpec {
    protected String missionId;
    protected String personId;
    protected Set<String> tags = new HashSet<String>();
    protected Set<String> tagsAny = new HashSet<String>();
    protected Set<String> tagsAll = new HashSet<String>();
    protected Set<String> tagsNotAny = new HashSet<String>();
    protected Set<String> reqMissionAny = new HashSet<String>();
    protected Set<String> reqMissionAll = new HashSet<String>();
    protected Set<String> reqMissionNone = new HashSet<String>();
    protected RepLevel min;
    protected RepLevel max;
    protected float freq;
    protected float minTimeout;
    protected float maxTimeout;
    protected PersonImportance importance;
    protected String pluginClass;
    protected String icon;

    public PersonMissionSpec(JSONObject row) throws JSONException {
        String tag;
        String[] stringArray;
        String[] split;
        String reqs;
        String tagsStr;
        String requiresNotAny;
        String requiresAnyStr;
        int n;
        String requiresAllStr;
        this.missionId = row.getString("mission id");
        this.personId = row.optString("person id", null);
        if (this.personId != null && this.personId.isEmpty()) {
            this.personId = null;
        }
        this.min = Misc.mapToEnum(row, "min rep", RepLevel.class, RepLevel.VENGEFUL);
        this.max = Misc.mapToEnum(row, "max rep", RepLevel.class, RepLevel.COOPERATIVE);
        this.freq = (float)row.optDouble("freq", 10.0);
        this.minTimeout = (float)row.optDouble("min timeout", 10.0);
        this.maxTimeout = (float)row.optDouble("max timeout", 10.0);
        this.importance = Misc.mapToEnum(row, "importance", PersonImportance.class, PersonImportance.VERY_LOW);
        this.pluginClass = row.getString("plugin");
        this.icon = row.optString("icon");
        if (this.icon == null || this.icon.isEmpty()) {
            this.icon = null;
        }
        if ((requiresAllStr = row.optString("tagsAll", null)) != null) {
            String[] split2;
            String[] stringArray2 = split2 = requiresAllStr.split(",");
            n = split2.length;
            int n2 = 0;
            while (n2 < n) {
                String tag2 = stringArray2[n2];
                if (!(tag2 = tag2.trim()).isEmpty()) {
                    this.tagsAll.add(tag2);
                }
                ++n2;
            }
        }
        if ((requiresAnyStr = row.optString("tagsAny", null)) != null) {
            String[] split3;
            String[] stringArray3 = split3 = requiresAnyStr.split(",");
            int n3 = split3.length;
            n = 0;
            while (n < n3) {
                String tag3 = stringArray3[n];
                if (!(tag3 = tag3.trim()).isEmpty()) {
                    this.tagsAny.add(tag3);
                }
                ++n;
            }
        }
        if ((requiresNotAny = row.optString("tagsNotAny", null)) != null) {
            String[] split4;
            String[] stringArray4 = split4 = requiresNotAny.split(",");
            int n4 = split4.length;
            int n5 = 0;
            while (n5 < n4) {
                String tag4 = stringArray4[n5];
                if (!(tag4 = tag4.trim()).isEmpty()) {
                    this.tagsNotAny.add(tag4);
                }
                ++n5;
            }
        }
        if ((tagsStr = row.optString("tags", null)) != null) {
            String[] split5;
            String[] stringArray5 = split5 = tagsStr.split(",");
            int n6 = split5.length;
            int n7 = 0;
            while (n7 < n6) {
                String tag5 = stringArray5[n7];
                if (!(tag5 = tag5.trim()).isEmpty()) {
                    this.tags.add(tag5);
                }
                ++n7;
            }
        }
        if ((reqs = row.optString("reqMissionAny", null)) != null) {
            stringArray = split = reqs.split(",");
            int n8 = split.length;
            int n9 = 0;
            while (n9 < n8) {
                tag = stringArray[n9];
                if (!(tag = tag.trim()).isEmpty()) {
                    this.reqMissionAny.add(tag);
                }
                ++n9;
            }
        }
        if ((reqs = row.optString("reqMissionAll", null)) != null) {
            stringArray = split = reqs.split(",");
            int n10 = split.length;
            int n11 = 0;
            while (n11 < n10) {
                tag = stringArray[n11];
                if (!(tag = tag.trim()).isEmpty()) {
                    this.reqMissionAll.add(tag);
                }
                ++n11;
            }
        }
        if ((reqs = row.optString("reqMissionNone", null)) != null) {
            stringArray = split = reqs.split(",");
            int n12 = split.length;
            int n13 = 0;
            while (n13 < n12) {
                tag = stringArray[n13];
                if (!(tag = tag.trim()).isEmpty()) {
                    this.reqMissionNone.add(tag);
                }
                ++n13;
            }
        }
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Set<String> getReqMissionAny() {
        return this.reqMissionAny;
    }

    public Set<String> getReqMissionAll() {
        return this.reqMissionAll;
    }

    public Set<String> getReqMissionNone() {
        return this.reqMissionNone;
    }

    public String getMissionId() {
        return this.missionId;
    }

    public void setMissionId(String missionId) {
        this.missionId = missionId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public RepLevel getMinRep() {
        return this.min;
    }

    public void setMinRep(RepLevel min) {
        this.min = min;
    }

    public RepLevel getMaxRep() {
        return this.max;
    }

    public void setMaxRep(RepLevel max) {
        this.max = max;
    }

    public float getFreq() {
        return this.freq;
    }

    public void setFreq(float freq) {
        this.freq = freq;
    }

    public float getMinTimeout() {
        return this.minTimeout;
    }

    public void setMinTimeout(float minTimeout) {
        this.minTimeout = minTimeout;
    }

    public float getMaxTimeout() {
        return this.maxTimeout;
    }

    public void setMaxTimeout(float maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    public PersonImportance getImportance() {
        return this.importance;
    }

    public void setImportance(PersonImportance importance) {
        this.importance = importance;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public void setPluginClass(String pluginClass) {
        this.pluginClass = pluginClass;
    }

    public Set<String> getTagsAny() {
        return this.tagsAny;
    }

    public Set<String> getTagsAll() {
        return this.tagsAll;
    }

    public Set<String> getTagsNotAny() {
        return this.tagsNotAny;
    }

    public HubMission createMission() {
        HubMission mission = (HubMission)Global.getSettings().getInstanceOfScript(this.pluginClass);
        mission.setMissionId(this.missionId);
        if (this.icon != null && mission instanceof BaseHubMission) {
            BaseHubMission bhm = (BaseHubMission)mission;
            bhm.setIconName(this.icon);
        }
        return mission;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public boolean tagsMatch(Set<String> tags) {
        boolean foundAll = true;
        for (String tag : this.getTagsAll()) {
            if (tags.contains(tag)) continue;
            foundAll = false;
            break;
        }
        if (!foundAll && !this.getTagsAll().isEmpty()) {
            return false;
        }
        boolean foundOne = false;
        for (String tag : this.getTagsAny()) {
            if (!tags.contains(tag)) continue;
            foundOne = true;
            break;
        }
        if (!foundOne && !this.getTagsAny().isEmpty()) {
            return false;
        }
        foundOne = false;
        for (String tag : this.getTagsNotAny()) {
            if (!tags.contains(tag)) continue;
            foundOne = true;
            break;
        }
        return !foundOne;
    }

    public boolean completedMissionsMatch(Set<String> completed) {
        boolean foundAll = true;
        for (String id : this.getReqMissionAll()) {
            if (completed.contains(id)) continue;
            foundAll = false;
            break;
        }
        if (!foundAll && !this.getReqMissionAll().isEmpty()) {
            return false;
        }
        boolean foundOne = false;
        for (String id : this.getReqMissionAny()) {
            if (!completed.contains(id)) continue;
            foundOne = true;
            break;
        }
        if (!foundOne && !this.getReqMissionAny().isEmpty()) {
            return false;
        }
        foundOne = false;
        for (String tag : this.getReqMissionNone()) {
            if (!completed.contains(tag)) continue;
            foundOne = true;
            break;
        }
        return !foundOne;
    }
}

