/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.plugins;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.procgen.themes.DerelictThemeGenerator;
import java.util.Map;

public interface SurveyPlugin {
    public void init(CampaignFleetAPI var1, PlanetAPI var2);

    public Map<String, Integer> getRequired();

    public Map<String, Integer> getConsumed();

    public String getImageCategory();

    public String getImageKey();

    public MutableStat getCostMult();

    public long getXP();

    public long getBaseXPForCondition(String var1);

    public MutableStat getXPMult();

    public String getSurveyDataType(PlanetAPI var1);

    default public int getSurveyDataScore(PlanetAPI planet) {
        if (planet.getMarket() == null) {
            return 0;
        }
        int count = 0;
        float value = 0.0f;
        for (MarketConditionAPI mc : planet.getMarket().getConditions()) {
            if (DerelictThemeGenerator.interestingConditionsWithRuins.contains(mc.getId())) {
                ++count;
            }
            if (mc.getGenSpec() == null) continue;
            value += mc.getGenSpec().getRank();
        }
        if (planet.getMarket().hasCondition("habitable")) {
            value += 4.0f;
        }
        float hazard = planet.getMarket().getHazardValue();
        return (int)(value -= (hazard - 1.0f) * 2.0f);
    }

    public Map<String, Integer> getOutpostConsumed();
}

