/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.CampaignEngineGlowUtil;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.FlickerUtilV2;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class CampaignEngineGlowIndividualEngine {
    protected float angle;
    protected float length;
    protected float glowSize;
    protected float width;
    protected float flameTexSpanMult = 1.0f;
    protected Vector2f offset;
    protected Color fringe;
    protected Color core;
    protected Color flameColor;
    protected FaderUtil fader = new FaderUtil(0.0f, 1.0f, 1.0f);
    protected FlickerUtilV2 flicker = new FlickerUtilV2();
    protected float texOffset;
    protected CampaignEngineGlowUtil main;
    protected transient SpriteAPI glow;
    protected transient SpriteAPI flame;

    public CampaignEngineGlowIndividualEngine(float angle, float length, float width, float glowSize, Vector2f offset, CampaignEngineGlowUtil main) {
        this.angle = angle;
        this.length = length;
        this.glowSize = glowSize;
        this.width = width;
        this.offset = offset;
        this.main = main;
        this.fader.fadeIn();
        this.readResolve();
    }

    protected Object readResolve() {
        this.glow = Global.getSettings().getSprite("campaignEntities", "campaign_engine_glow");
        this.flame = Global.getSettings().getSprite("campaignEntities", "campaign_engine_flame");
        return this;
    }

    public void advance(float amount) {
        this.fader.advance(amount);
        this.flicker.advance(amount * this.main.getFlickerRateMult().getCurr());
        this.texOffset -= amount * this.main.getTextureScrollMult().getCurr();
        while (this.texOffset < 0.0f) {
            this.texOffset += 1.0f;
        }
    }

    public void render(Vector2f center, float facing, float alphaMult) {
        alphaMult *= this.fader.getBrightness();
        float f = this.main.getFlickerMult().getCurr();
        if (f > 0.0f) {
            alphaMult *= 1.0f - this.flicker.getBrightness() * f;
        }
        if (alphaMult <= 0.0f) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)center.x, (float)center.y, (float)0.0f);
        GL11.glRotatef((float)facing, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)this.offset.x, (float)this.offset.y, (float)0.0f);
        this.renderFlame(alphaMult);
        this.renderGlow(alphaMult);
        GL11.glPopMatrix();
    }

    protected void renderFlame(float alphaMult) {
        float lengthMult = this.main.getLengthMult().getCurr();
        float widthMult = this.main.getWidthMult().getCurr();
        if (lengthMult <= 0.0f || widthMult <= 0.0f || this.width <= 0.0f || this.length <= 0.0f) {
            return;
        }
        this.flame.bindTexture();
        Color base = this.main.getFlameColor().getCurr();
        if (this.flameColor != null) {
            base = this.flameColor;
        }
        Color dim = Misc.setAlpha(base, 0);
        float w = this.width * widthMult;
        float len = this.length * lengthMult;
        float bit = 0.01f;
        float fadeInPortion = Math.min(w / 2.0f, len / 4.0f);
        float fadeInTex = fadeInPortion / len;
        float flameTexSpan = 1.0f;
        flameTexSpan = len / w * 0.25f;
        flameTexSpan *= this.flameTexSpanMult;
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float num = 11.0f;
        float f = 1.0f;
        while (f <= num) {
            float b = alphaMult * f / num;
            float wMult = 1.0f - (f - 1.0f) / (num - 1.0f);
            float lMult = f / num;
            lMult = 0.5f + 0.5f * lMult;
            float texPlus = (f - 1.0f) * 1.0f / num;
            GL11.glBegin((int)8);
            Misc.setColor(dim, alphaMult * b);
            GL11.glTexCoord2f((float)(this.texOffset + texPlus), (float)(0.0f + bit));
            GL11.glVertex2f((float)0.0f, (float)(-w / 2.0f * wMult));
            GL11.glTexCoord2f((float)(this.texOffset + texPlus), (float)(1.0f - bit));
            GL11.glVertex2f((float)0.0f, (float)(w / 2.0f * wMult));
            Misc.setColor(base, alphaMult * b);
            GL11.glTexCoord2f((float)(this.texOffset + fadeInTex + texPlus), (float)(0.0f + bit));
            GL11.glVertex2f((float)(-fadeInPortion * lMult), (float)(-w / 2.0f * wMult));
            GL11.glTexCoord2f((float)(this.texOffset + fadeInTex + texPlus), (float)(1.0f - bit));
            GL11.glVertex2f((float)(-fadeInPortion * lMult), (float)(w / 2.0f * wMult));
            Misc.setColor(dim, alphaMult * b);
            GL11.glTexCoord2f((float)(this.texOffset + flameTexSpan + texPlus), (float)(0.0f + bit));
            GL11.glVertex2f((float)(-len * lMult), (float)(-w / 2.0f * wMult));
            GL11.glTexCoord2f((float)(this.texOffset + flameTexSpan + texPlus), (float)(1.0f - bit));
            GL11.glVertex2f((float)(-len * lMult), (float)(w / 2.0f * wMult));
            GL11.glEnd();
            f += 1.0f;
        }
    }

    protected void renderGlow(float alphaMult) {
        float w = this.glowSize;
        float h = this.glowSize;
        float glowScale = this.main.getGlowMult().getCurr();
        float fringeScale = glowScale * this.main.getGlowFringeMult().getCurr();
        float coreScale = glowScale * this.main.getGlowCoreMult().getCurr();
        if (glowScale <= 0.0f) {
            return;
        }
        Color fringeColor = this.main.getGlowColorFringe().getCurr();
        if (this.fringe != null) {
            fringeColor = this.fringe;
        }
        Color coreColor = this.main.getGlowColorCore().getCurr();
        if (this.core != null) {
            coreColor = this.core;
        }
        this.glow.setColor(fringeColor);
        this.glow.setAdditiveBlend();
        this.glow.setAlphaMult(alphaMult * 0.5f);
        this.glow.setSize(w * fringeScale, h * fringeScale);
        this.glow.renderAtCenter(0.0f, 0.0f);
        this.glow.setColor(coreColor);
        int i = 0;
        while (i < 2) {
            this.glow.setSize((w *= 0.3f) * coreScale, (h *= 0.3f) * coreScale);
            this.glow.setAlphaMult(alphaMult * 0.67f);
            this.glow.renderAtCenter(0.0f, 0.0f);
            ++i;
        }
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        this.length = length;
    }

    public float getGlowSize() {
        return this.glowSize;
    }

    public void setGlowSize(float glowSize) {
        this.glowSize = glowSize;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public Vector2f getOffset() {
        return this.offset;
    }

    public void setOffset(Vector2f offset) {
        this.offset = offset;
    }

    public Color getFringe() {
        return this.fringe;
    }

    public void setFringe(Color fringe) {
        this.fringe = fringe;
    }

    public Color getCore() {
        return this.core;
    }

    public void setCore(Color core) {
        this.core = core;
    }

    public CampaignEngineGlowUtil getMain() {
        return this.main;
    }

    public void setMain(CampaignEngineGlowUtil main) {
        this.main = main;
    }

    public SpriteAPI getGlow() {
        return this.glow;
    }

    public void setGlow(SpriteAPI glow) {
        this.glow = glow;
    }

    public FaderUtil getFader() {
        return this.fader;
    }

    public Color getFlameColor() {
        return this.flameColor;
    }

    public void setFlameColor(Color flameColor) {
        this.flameColor = flameColor;
    }

    public float getFlameTexSpanMult() {
        return this.flameTexSpanMult;
    }

    public void setFlameTexSpanMult(float flameTexSpanMult) {
        this.flameTexSpanMult = flameTexSpanMult;
    }
}

