/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.SmoothFacingUtil;
import com.fs.starfarer.api.util.SmoothMovementUtil;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class CampaignEntityMovementUtil {
    public static float DIRECTION_UNSET = Float.MAX_VALUE;
    protected SectorEntityToken entity;
    protected SmoothFacingUtil facingUtil;
    protected SmoothMovementUtil movementUtil;
    protected boolean turnThenAccelerate = true;
    protected boolean faceInOppositeDirection = false;
    protected float moveDir;
    protected float desiredFacing = DIRECTION_UNSET;
    protected Vector2f moveDest;
    protected EngineGlowControls engineGlow;

    public CampaignEntityMovementUtil(SectorEntityToken entity, float turnAccel, float maxTurnRate, float accel, float maxSpeed) {
        this.entity = entity;
        this.facingUtil = new SmoothFacingUtil(turnAccel, maxTurnRate);
        this.movementUtil = new SmoothMovementUtil();
        this.movementUtil.setAcceleration(accel);
        this.movementUtil.setMaxSpeed(maxSpeed);
        this.moveDir = DIRECTION_UNSET;
        this.moveDest = null;
    }

    public boolean isFaceInOppositeDirection() {
        return this.faceInOppositeDirection;
    }

    public void setFaceInOppositeDirection(boolean faceInOppositeDirection) {
        this.faceInOppositeDirection = faceInOppositeDirection;
    }

    public boolean isTurnThenAccelerate() {
        return this.turnThenAccelerate;
    }

    public void setTurnThenAccelerate(boolean turnThenAccelerate) {
        this.turnThenAccelerate = turnThenAccelerate;
    }

    public SmoothFacingUtil getFacingUtil() {
        return this.facingUtil;
    }

    public SmoothMovementUtil getMovementUtil() {
        return this.movementUtil;
    }

    public void moveInDirection(float dir) {
        this.moveDir = dir;
        this.moveDest = null;
        this.leaveOrbit();
    }

    public void moveToLocation(Vector2f loc) {
        this.moveDir = DIRECTION_UNSET;
        this.moveDest = loc;
        this.leaveOrbit();
    }

    public void stop() {
        this.moveDir = DIRECTION_UNSET;
        this.moveDest = new Vector2f((ReadableVector2f)this.entity.getLocation());
        this.leaveOrbit();
    }

    public void leaveOrbit() {
        if (this.entity.getOrbit() != null) {
            this.setFacing(this.entity.getFacing());
            this.setLocation(this.entity.getLocation());
            this.setVelocity(this.entity.getVelocity());
            this.entity.setOrbit(null);
        }
    }

    protected Vector2f getPointInDirectionOppositeToVelocity() {
        Vector2f p = new Vector2f((ReadableVector2f)this.entity.getLocation());
        if (this.entity.getVelocity().length() > 0.0f) {
            Vector2f back = new Vector2f((ReadableVector2f)this.entity.getVelocity());
            Misc.normalise(back);
            back.negate();
            back.scale(10.0f);
            Vector2f.add((Vector2f)back, (Vector2f)this.entity.getLocation(), (Vector2f)back);
            p = back;
        }
        return p;
    }

    public void advance(float amount) {
        if (this.entity.getOrbit() == null) {
            boolean turnOnly;
            Vector2f dest;
            if (this.moveDir != DIRECTION_UNSET) {
                dest = Misc.getUnitVectorAtDegreeAngle(this.moveDir);
                dest.scale(1.0E8f);
                Vector2f.add((Vector2f)dest, (Vector2f)this.entity.getLocation(), (Vector2f)dest);
                this.desiredFacing = this.moveDir;
            } else if (this.moveDest != null) {
                this.desiredFacing = Misc.getAngleInDegrees(this.entity.getLocation(), this.moveDest);
                dest = this.moveDest;
            } else {
                this.desiredFacing = this.entity.getFacing();
                dest = this.getPointInDirectionOppositeToVelocity();
            }
            if (this.faceInOppositeDirection) {
                this.desiredFacing += 180.0f;
            }
            float angleDiff = Misc.getAngleDiff(this.entity.getFacing(), this.desiredFacing);
            boolean bl = turnOnly = this.turnThenAccelerate && angleDiff > 2.0f;
            if (turnOnly) {
                dest = this.getPointInDirectionOppositeToVelocity();
            }
            this.movementUtil.setDest(dest, new Vector2f());
            this.movementUtil.advance(amount);
            this.facingUtil.advance(this.desiredFacing, amount);
            this.entity.setFacing(this.facingUtil.getFacing());
            this.entity.getLocation().set((ReadableVector2f)this.movementUtil.getLocation());
            this.entity.getVelocity().set((ReadableVector2f)this.movementUtil.getVelocity());
            if (this.engineGlow != null) {
                if (turnOnly || angleDiff > 30.0f) {
                    this.engineGlow.showOtherAction();
                } else {
                    this.engineGlow.showAccelerating();
                }
            }
        } else {
            if (this.engineGlow != null) {
                this.engineGlow.showIdling();
            }
            this.desiredFacing = DIRECTION_UNSET;
        }
    }

    public boolean isDesiredFacingSet() {
        return this.desiredFacing != DIRECTION_UNSET;
    }

    public float getDesiredFacing() {
        return this.desiredFacing;
    }

    public SectorEntityToken getEntity() {
        return this.entity;
    }

    public void setFacing(float facing) {
        this.facingUtil.setFacing(facing);
        this.entity.setFacing(facing);
    }

    public void setLocation(Vector2f loc) {
        this.movementUtil.getLocation().set((ReadableVector2f)loc);
        this.entity.getLocation().set((ReadableVector2f)this.movementUtil.getLocation());
    }

    public void setVelocity(Vector2f vel) {
        this.movementUtil.getVelocity().set((ReadableVector2f)vel);
        this.entity.getVelocity().set((ReadableVector2f)this.movementUtil.getVelocity());
    }

    public EngineGlowControls getEngineGlow() {
        return this.engineGlow;
    }

    public void setEngineGlow(EngineGlowControls engineGlow) {
        this.engineGlow = engineGlow;
    }

    public static interface EngineGlowControls {
        public void showAccelerating();

        public void showIdling();

        public void showSuppressed();

        public void showOtherAction();
    }
}

