/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

public class MutatingValueUtil {
    private float value;
    private float min;
    private float max;
    private float rate;
    private float rateSign;
    private float rateMult = 1.0f;
    private float valueMult = 1.0f;
    private float sign = 0.0f;

    public MutatingValueUtil() {
    }

    public MutatingValueUtil(float min, float max, float rate) {
        this.min = min;
        this.max = max;
        this.rate = Math.abs(rate);
        this.value = min + (float)Math.random() * (max - min);
        this.rateSign = Math.signum(rate);
    }

    public void advance(float amount) {
        this.value = this.rateSign != 0.0f ? (this.value += amount * this.rate * this.rateSign * this.rateMult) : (this.value += amount * this.rate * this.rateMult);
        if (this.value > this.max) {
            this.rateSign = -1.0f;
        } else if (this.value < this.min) {
            this.rateSign = 1.0f;
        }
    }

    public float getRateMult() {
        return this.rateMult;
    }

    public void setRateMult(float rateMult) {
        this.rateMult = rateMult;
    }

    public float getValue() {
        if (this.sign != 0.0f) {
            return this.value * this.sign * this.valueMult;
        }
        return this.value * this.valueMult;
    }

    public float getValueMult() {
        return this.valueMult;
    }

    public void setValueMult(float valueMult) {
        this.valueMult = valueMult;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = Math.abs(rate);
    }

    public float getSign() {
        return this.sign;
    }

    public void setSign(float sign) {
        this.sign = Math.signum(sign);
    }

    public void setRandomSign() {
        this.sign = (float)Math.signum(Math.random() - 0.5);
        if (this.sign == 0.0f) {
            this.sign = 1.0f;
        }
    }

    public void setRandomRateSign() {
        this.rateSign = (float)Math.signum(Math.random() - 0.5);
        if (this.rateSign == 0.0f) {
            this.rateSign = 1.0f;
        }
    }

    public float getRateSign() {
        return this.rateSign;
    }

    public void setRateSign(float rateSign) {
        this.rateSign = rateSign;
    }
}

