/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.util.Misc;
import java.util.Arrays;
import java.util.Random;

public class Noise {
    public static Random random = new Random(Misc.genRandomSeed());

    public static float[] genNoise(int size, float spikes) {
        float[] noise = new float[size];
        Arrays.fill(noise, -1.0f);
        noise[0] = 1.0f;
        noise[size - 1] = 1.0f;
        Noise.genNoise(noise, 0, size - 1, 1, spikes);
        Noise.normalizeNoise(noise, 0.0f, 1.0f);
        return noise;
    }

    public static void genNoise(float[] noise, int x1, int x2, int iter, float spikes) {
        if (x1 + 1 >= x2) {
            return;
        }
        int midX = (x1 + x2) / 2;
        Noise.fill(noise, midX, x1, x2, iter, spikes);
        Noise.genNoise(noise, x1, midX, iter + 1, spikes);
        Noise.genNoise(noise, midX, x2, iter + 1, spikes);
    }

    private static void normalizeNoise(float[] noise, float min, float max) {
        float minNoise = Float.MAX_VALUE;
        float maxNoise = -3.4028235E38f;
        int i = 0;
        while (i < noise.length) {
            if (noise[i] != -1.0f) {
                if (noise[i] > maxNoise) {
                    maxNoise = noise[i];
                }
                if (noise[i] < minNoise) {
                    minNoise = noise[i];
                }
            }
            ++i;
        }
        if (minNoise >= maxNoise) {
            return;
        }
        float range = maxNoise - minNoise;
        int i2 = 0;
        while (i2 < noise.length) {
            noise[i2] = noise[i2] != -1.0f ? min + (noise[i2] - minNoise) / range * (max - min) : (i2 > 0 ? noise[i2 - 1] : (i2 < noise.length - 1 ? noise[i2 + 1] : 0.5f));
            ++i2;
        }
    }

    private static void fill(float[] noise, int x, int x1, int x2, int iter, float spikes) {
        if (noise[x] == -1.0f) {
            float avg = (noise[x1] + noise[x2]) / 2.0f;
            noise[x] = avg + (float)Math.pow(spikes, iter) * (float)(random.nextDouble() - 0.5);
        }
    }
}

