/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.util.IntervalUtil;

public class RollingAverageTracker {
    private IntervalUtil timer;
    private final float f;
    private float elaspedFractionOverride = -1.0f;
    private float curr = 0.0f;
    private float avg = 0.0f;

    public RollingAverageTracker(float minInterval, float maxInterval, float factor) {
        this.f = factor;
        this.timer = new IntervalUtil(minInterval, maxInterval);
    }

    public void advance(float amount) {
        this.timer.advance(amount);
        if (this.timer.intervalElapsed()) {
            this.updateAverage();
        }
    }

    public void updateAverage() {
        this.avg = this.avg <= 0.0f ? this.curr : this.avg * (1.0f - this.f) + this.curr * this.f;
        this.curr = 0.0f;
    }

    public float getCurr() {
        return this.curr;
    }

    public float getAverage() {
        float e = this.timer.getElapsed() / this.timer.getIntervalDuration();
        if (this.elaspedFractionOverride >= 0.0f) {
            e = this.elaspedFractionOverride;
        }
        return this.avg * (1.0f - this.f * e) + this.curr * this.f * e;
    }

    public void add(float val) {
        this.curr += val;
    }

    public void sub(float val) {
        this.curr -= val;
        if (this.curr < 0.0f) {
            this.curr = 0.0f;
        }
    }

    public void setElaspedFractionOverride(float elaspedFractionOverride) {
        this.elaspedFractionOverride = elaspedFractionOverride;
    }
}

