/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.util.Misc;

public class SmoothFacingUtil {
    private float turnAcceleration;
    private float maxTurnRate;
    private float turnRate;
    private float facing;

    public SmoothFacingUtil(float turnAcceleration, float maxTurnRate) {
        this.turnAcceleration = turnAcceleration;
        this.maxTurnRate = maxTurnRate;
    }

    public void advance(float desiredFacing, float amount) {
        float absTurnRate = Math.abs(this.turnRate);
        float decelTime = absTurnRate / this.turnAcceleration;
        float decelDistance = absTurnRate * decelTime - 0.5f * this.turnAcceleration * decelTime * decelTime;
        float diffWithCurrFacing = Misc.getAngleDiff(this.facing, desiredFacing);
        float turnDir = Misc.getClosestTurnDirection(this.facing, desiredFacing);
        if (Math.signum(this.turnRate) == Math.signum(turnDir) && decelDistance >= diffWithCurrFacing) {
            turnDir = -turnDir;
        }
        this.turnRate += turnDir * this.turnAcceleration * amount;
        if (Math.abs(this.turnRate) > this.maxTurnRate) {
            this.turnRate = this.maxTurnRate * Math.signum(this.turnRate);
        }
        this.facing += this.turnRate * amount;
        this.facing = Misc.normalizeAngle(this.facing);
        if (diffWithCurrFacing < this.turnRate * amount * 1.5f) {
            this.facing = desiredFacing;
        }
    }

    public float getFacing() {
        return this.facing;
    }

    public void setFacing(float facing) {
        this.facing = facing;
    }

    public float getTurnAcceleration() {
        return this.turnAcceleration;
    }

    public void setTurnAcceleration(float turnAcceleration) {
        this.turnAcceleration = turnAcceleration;
    }

    public float getMaxTurnRate() {
        return this.maxTurnRate;
    }

    public void setMaxTurnRate(float maxTurnRate) {
        this.maxTurnRate = maxTurnRate;
    }

    public float getTurnRate() {
        return this.turnRate;
    }

    public void setTurnRate(float turnRate) {
        this.turnRate = turnRate;
    }
}

