/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.anim;

import com.fs.graphics.anim.Animation;
import com.fs.graphics.util.GenericTask;
import java.util.ArrayList;
import java.util.List;

public class AnimationChain
implements Animation {
    private List<Animation> animations = new ArrayList<Animation>();
    private GenericTask before;
    private GenericTask after;
    Animation curr = null;

    @Override
    public void advance(float f) {
        boolean bl = false;
        while (!this.animations.isEmpty() && !bl) {
            if (this.curr == null) {
                this.curr = this.animations.remove(0);
                this.curr.started();
            }
            if (this.curr.isDone()) {
                this.curr.finished();
                this.curr = null;
                continue;
            }
            this.curr.advance(f);
            bl = true;
        }
    }

    @Override
    public boolean isDone() {
        return this.animations.isEmpty() && this.curr == null;
    }

    public void addAnimation(Animation animation) {
        this.animations.add(animation);
    }

    @Override
    public void finished() {
        if (this.after != null) {
            this.after.perform();
        }
    }

    @Override
    public void started() {
        if (this.before != null) {
            this.before.perform();
        }
    }
}

