/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.anim;

import com.fs.graphics.anim.Animation;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AnimationManager
implements DoNotObfuscate {
    private static AnimationManager instance;
    private static Map<String, AnimationManager> managers;
    private List<Animation> animations = new ArrayList<Animation>();
    private List<Animation> added = new ArrayList<Animation>();
    private List<Animation> removing = new ArrayList<Animation>();
    private List<Animation> starting = new ArrayList<Animation>();
    private boolean paused = false;

    static {
        managers = new HashMap<String, AnimationManager>();
    }

    Object readResolve() {
        if (this.removing == null) {
            this.removing = new ArrayList<Animation>();
        }
        return this;
    }

    public static void advanceAllGroups(float f) {
        if (instance != null) {
            instance.advanceAll(f);
        }
        for (AnimationManager animationManager : managers.values()) {
            animationManager.advanceAll(f);
        }
    }

    public static AnimationManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new AnimationManager();
        return instance;
    }

    public static AnimationManager getInstance(String string) {
        AnimationManager animationManager = managers.get(string);
        if (animationManager != null) {
            return animationManager;
        }
        animationManager = new AnimationManager();
        managers.put(string, animationManager);
        return animationManager;
    }

    public void pauseAll() {
        this.paused = true;
    }

    public void resumeAll() {
        this.paused = false;
    }

    public void addAnimation(Animation animation) {
        this.added.add(animation);
    }

    public void removeAnimation(Animation animation) {
        this.added.remove(animation);
        this.removing.add(animation);
    }

    public void clear() {
        this.starting.clear();
        this.added.clear();
        this.animations.clear();
        if (this.removing != null) {
            this.removing.clear();
        }
    }

    public void advanceAll(float f) {
        if (this.paused) {
            return;
        }
        this.starting.clear();
        this.starting.addAll(this.added);
        this.added.clear();
        for (Animation animation : this.starting) {
            animation.started();
            this.animations.add(animation);
        }
        this.checkFinished();
        for (Animation animation : this.animations) {
            animation.advance(f);
        }
        this.animations.removeAll(this.removing);
        this.removing.clear();
        this.checkFinished();
    }

    private void checkFinished() {
        Iterator<Animation> iterator = this.animations.iterator();
        while (iterator.hasNext()) {
            Animation animation = iterator.next();
            if (!animation.isDone()) continue;
            animation.finished();
            iterator.remove();
        }
    }
}

