/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.particle;

import com.fs.graphics.anim.BaseAnimation;
import com.fs.graphics.particle.BaseParticle;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class DynamicParticleGroup
extends BaseAnimation
implements DoNotObfuscate {
    private LinkedList<BaseParticle> particles = new LinkedList();
    private int limit = Integer.MAX_VALUE;

    public DynamicParticleGroup(int n) {
        this.limit = n;
    }

    public DynamicParticleGroup() {
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public int size() {
        return this.particles.size();
    }

    public void add(BaseParticle baseParticle) {
        if (this.particles.size() >= this.limit) {
            this.particles.removeFirst();
        }
        this.particles.add(baseParticle);
    }

    public void render(float f, float f2) {
        if (this.particles.isEmpty()) {
            return;
        }
        BaseParticle baseParticle = this.particles.get(0);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)f, (float)f2, (float)0.0f);
        baseParticle.preBatch();
        for (BaseParticle baseParticle2 : this.particles) {
            baseParticle2.render();
        }
        baseParticle.postBatch();
        GL11.glTranslatef((float)(-f), (float)(-f2), (float)0.0f);
        GL11.glPopMatrix();
    }

    @Override
    public void advance(float f) {
        ArrayList<BaseParticle> arrayList = new ArrayList<BaseParticle>();
        for (BaseParticle baseParticle : this.particles) {
            baseParticle.advance(f);
            if (!baseParticle.isExpired()) continue;
            arrayList.add(baseParticle);
        }
        this.particles.removeAll(arrayList);
        arrayList.clear();
    }

    public boolean isEmpty() {
        return this.particles.isEmpty();
    }

    public List<BaseParticle> getParticles() {
        return this.particles;
    }
}

