/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.particle;

import com.fs.graphics.Object;
import com.fs.graphics.particle.BaseParticle;
import com.fs.graphics.util.B;
import com.fs.graphics.void;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.io.IOException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class TexturedLine
extends BaseParticle
implements DoNotObfuscate {
    private Object texture;
    private float x1 = 0.0f;
    private float y1 = 0.0f;
    private float x2 = 50.0f;
    private float y2 = 0.0f;
    private float widthFrom = 10.0f;
    private float widthTo = 10.0f;
    private Color colorFrom = new Color(255, 255, 255, 255);
    private Color colorTo = new Color(255, 255, 255, 255);
    private float tx1 = 0.0f;
    private float ty1 = 0.0f;
    private float tx2 = 1.0f;
    private float ty2 = 1.0f;
    private static final String TEXTURE_ID_LN = "fs.common/graphics/particleline32ln.png";
    private static final String TEXTURE_FILE_LN = "graphics/particleline32ln.png";
    private static final String TEXTURE_ID_SQ = "fs.common/graphics/particleline32sq.png";
    private static final String TEXTURE_FILE_SQ = "graphics/particleline32sq.png";
    private Vector2f perp = new Vector2f();

    public TexturedLine() {
        this(o.\u00d300000);
    }

    public TexturedLine(o o2) {
        String string;
        String string2;
        if (o2 == o.o00000) {
            string2 = TEXTURE_ID_LN;
            string = TEXTURE_FILE_LN;
        } else {
            string2 = TEXTURE_ID_SQ;
            string = TEXTURE_FILE_SQ;
        }
        this.texture = void.\u00d200000(string2);
        if (this.texture == null) {
            try {
                void.o00000(string2, string);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.texture = void.\u00d200000(string2);
            if (this.texture == null) {
                throw new RuntimeException("Error loading texturedline particle texture");
            }
        }
    }

    public TexturedLine(Object object) {
        this.setTexture(object);
    }

    public TexturedLine(Object object, Color color) {
        this.setTexture(object);
        this.colorFrom = color;
        this.colorTo = color;
    }

    public void setTextureCoords(float f, float f2, float f3, float f4) {
        this.tx1 = f;
        this.tx2 = f3;
        this.ty1 = f2;
        this.ty2 = f4;
    }

    public void setTexture(Object object) {
        this.texture = object;
        this.tx1 = 0.0f;
        this.ty1 = 0.0f;
        this.tx2 = object.while();
        this.ty2 = object.o00000();
    }

    public void setWidth(float f) {
        this.widthFrom = f;
        this.widthTo = f;
    }

    public void setFrom(float f, float f2) {
        this.x1 = f;
        this.y1 = f2;
    }

    public void setTo(float f, float f2) {
        this.x2 = f;
        this.y2 = f2;
    }

    @Override
    public void render() {
        this.perp.set(this.y2 - this.y1, this.x2 - this.x1);
        if (this.perp.x != 0.0f || this.perp.y != 0.0f) {
            this.perp.normalise();
        }
        float f = this.perp.x * this.widthFrom / 2.0f;
        float f2 = this.perp.y * this.widthFrom / 2.0f;
        float f3 = this.perp.x * this.widthTo / 2.0f;
        float f4 = this.perp.y * this.widthTo / 2.0f;
        float f5 = this.getX();
        float f6 = this.getY();
        B.\u00d200000(B.\u00d300000(this.colorFrom, this.getBrightness()));
        GL11.glTexCoord2f((float)this.tx1, (float)this.ty1);
        GL11.glVertex2f((float)(this.x1 - f + f5), (float)(this.y1 + f2 + f6));
        GL11.glTexCoord2f((float)this.tx1, (float)this.ty2);
        GL11.glVertex2f((float)(this.x1 + f + f5), (float)(this.y1 - f2 + f6));
        B.\u00d200000(B.\u00d300000(this.colorTo, this.getBrightness()));
        GL11.glTexCoord2f((float)this.tx2, (float)this.ty2);
        GL11.glVertex2f((float)(this.x2 + f3 + f5), (float)(this.y2 - f4 + f6));
        GL11.glTexCoord2f((float)this.tx2, (float)this.ty1);
        GL11.glVertex2f((float)(this.x2 - f3 + f5), (float)(this.y2 + f4 + f6));
    }

    public void renderFixed() {
        this.perp.set(this.y2 - this.y1, this.x2 - this.x1);
        if (this.perp.x != 0.0f || this.perp.y != 0.0f) {
            this.perp.normalise();
        }
        float f = this.perp.x * this.widthFrom / 2.0f;
        float f2 = this.perp.y * this.widthFrom / 2.0f;
        float f3 = this.perp.x * this.widthTo / 2.0f;
        float f4 = this.perp.y * this.widthTo / 2.0f;
        float f5 = this.getX();
        float f6 = this.getY();
        B.\u00d200000(this.colorFrom);
        GL11.glTexCoord2f((float)this.tx1, (float)this.ty1);
        GL11.glVertex2f((float)(this.x1 - f + f5), (float)(this.y1 + f2 + f6));
        GL11.glTexCoord2f((float)this.tx1, (float)this.ty2);
        GL11.glVertex2f((float)(this.x1 + f + f5), (float)(this.y1 - f2 + f6));
        B.\u00d200000(this.colorTo);
        GL11.glTexCoord2f((float)this.tx2, (float)this.ty2);
        GL11.glVertex2f((float)(this.x2 + f3 + f5), (float)(this.y2 - f4 + f6));
        GL11.glTexCoord2f((float)this.tx2, (float)this.ty1);
        GL11.glVertex2f((float)(this.x2 - f3 + f5), (float)(this.y2 + f4 + f6));
    }

    @Override
    public void advance(float f) {
        super.advance(f);
        float f2 = this.getDx() * f;
        float f3 = this.getDy() * f;
        this.x1 += f2;
        this.x2 += f2;
        this.y1 += f3;
        this.y2 += f3;
    }

    @Override
    public void preBatch() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        this.texture.\u00d800000();
        GL11.glBegin((int)7);
    }

    @Override
    public void postBatch() {
        GL11.glEnd();
        GL11.glDisable((int)3553);
    }

    public void translate(float f, float f2) {
        this.x1 += f;
        this.x2 += f;
        this.y1 += f2;
        this.y2 += f2;
    }

    public Color getColor() {
        return this.colorFrom;
    }

    public void setColor(Color color) {
        this.colorFrom = color;
        this.colorTo = color;
    }

    public float getWidth() {
        return this.widthFrom;
    }

    public float getX1() {
        return this.x1;
    }

    public float getX2() {
        return this.x2;
    }

    public float getY1() {
        return this.y1;
    }

    public float getY2() {
        return this.y2;
    }

    public Object getTexture() {
        return this.texture;
    }

    public void setColorFrom(Color color) {
        this.colorFrom = color;
    }

    public void setColorTo(Color color) {
        this.colorTo = color;
    }

    public float getWidthFrom() {
        return this.widthFrom;
    }

    public void setWidthFrom(float f) {
        this.widthFrom = f;
    }

    public float getWidthTo() {
        return this.widthTo;
    }

    public void setWidthTo(float f) {
        this.widthTo = f;
    }

    @Override
    public void preBatch(int n) {
        this.preBatch();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum o {
        o00000,
        \u00d300000;

    }
}

