package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;
import com.fs.starfarer.api.impl.campaign.ids.Stats;
import com.fs.starfarer.api.impl.campaign.ids.Strings;

public class DefensiveSystems {
	
	public static final float FLUX_UPKEEP_REDUCTION = 25f;
	
	public static final float SHIELD_DAMAGE_REDUCTION = 20f;
	public static final float PHASE_COOLDOWN_REDUCTION = 25f;
	
	public static final float FLUX_SHUNT_DISSIPATION = 10f;
	

	public static class Level1 implements ShipSkillEffect {

		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getShieldUpkeepMult().modifyMult(id, 1f - FLUX_UPKEEP_REDUCTION / 100f);
			stats.getPhaseCloakUpkeepCostBonus().modifyMult(id, 1f - FLUX_UPKEEP_REDUCTION / 100f);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getShieldUpkeepMult().unmodify(id);
			stats.getPhaseCloakUpkeepCostBonus().unmodify(id);
		}
		
		public String getEffectDescription(float level) {
			return "-" + (int)(FLUX_UPKEEP_REDUCTION) + "% flux generated by active shields and phase cloak";
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}
		
		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}

	public static class Level2A implements ShipSkillEffect {
		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getShieldDamageTakenMult().modifyMult(id, 1f - SHIELD_DAMAGE_REDUCTION / 100f);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getShieldDamageTakenMult().unmodify(id);
		}
		
		public String getEffectDescription(float level) {
			return "-" + (int)(SHIELD_DAMAGE_REDUCTION) + "% damage taken by shields";
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}

		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}
	
	public static class Level2B implements ShipSkillEffect {
		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getPhaseCloakCooldownBonus().modifyMult(id, 1f - PHASE_COOLDOWN_REDUCTION / 100f);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getPhaseCloakCooldownBonus().unmodify(id);
		}
		
		public String getEffectDescription(float level) {
			return "-" + (int)(PHASE_COOLDOWN_REDUCTION) + "% phase cloak cooldown";
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}
		
		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}
	
	public static class Level3A implements ShipSkillEffect {

		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getHardFluxDissipationFraction().modifyFlat(id, FLUX_SHUNT_DISSIPATION / 100f);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getHardFluxDissipationFraction().unmodify(id);
		}	
		
		public String getEffectDescription(float level) {
			return "" + (int)(FLUX_SHUNT_DISSIPATION) + "% hard flux dissipation while shields are active";
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}
		
		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}
	
	public static class Level3B implements ShipSkillEffect {
		
		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			// 1f + 2 * (this stat), * 1.5 means 3x -> 4c
			stats.getDynamic().getStat(Stats.PHASE_TIME_BONUS_MULT).modifyFlat(id, 0.5f);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getDynamic().getStat(Stats.PHASE_TIME_BONUS_MULT).unmodify(id);
		}	
		
		public String getEffectDescription(float level) {
			return "Phase cloak time acceleration increased from 3" + Strings.X + " to 4" + Strings.X;
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}
		
		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}
	
}
