package com.fs.starfarer.api.impl.campaign.skills;

import org.lwjgl.util.vector.Vector2f;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.WeaponAPI.WeaponType;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class EnergyWeaponMastery {
	
	public static float FLUX_COST_MULT = .9f;
	
	public static float MIN_RANGE = 600;
	public static float MAX_RANGE = 1000;
	
	public static float ENERGY_DAMAGE_PERCENT = 30;
	//public static float ENERGY_DAMAGE_MIN_FLUX_LEVEL = 0.25f;
	public static float ENERGY_DAMAGE_MIN_FLUX_LEVEL = 0f;
	
	

	public static class Level1 extends BaseSkillEffectDescription implements AfterShipCreationSkillEffect {
		public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
			ship.addListener(new EWMDamageDealtMod(ship));
		}

		public void unapplyEffectsAfterShipCreation(ShipAPI ship, String id) {
			ship.removeListenerOfClass(EWMDamageDealtMod.class);
		}
		
		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getEnergyWeaponFluxBasedBonusDamageMagnitude().modifyFlat(id, ENERGY_DAMAGE_PERCENT * .01f);
			stats.getEnergyWeaponFluxBasedBonusDamageMinLevel().modifyFlat(id, ENERGY_DAMAGE_MIN_FLUX_LEVEL);
		}
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getEnergyWeaponFluxBasedBonusDamageMagnitude().unmodifyFlat(id);
			stats.getEnergyWeaponFluxBasedBonusDamageMinLevel().unmodifyFlat(id);
		}
		
		public String getEffectDescription(float level) {
			return null;
		}
		
		public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, 
											TooltipMakerAPI info, float width) {
			init(stats, skill);
			
			if (ENERGY_DAMAGE_MIN_FLUX_LEVEL > 0) {
				info.addPara("Energy weapons deal up to %s damage at close range as the firing ship's flux level increases above %s",
						0f, hc, hc,
						"+" + (int) ENERGY_DAMAGE_PERCENT + "%",
						(int) Math.round(ENERGY_DAMAGE_MIN_FLUX_LEVEL * 100f) + "%"
				);
			} else {
				info.addPara("Energy weapons deal up to %s damage at close range, based on the firing ship's flux level",
						0f, hc, hc,
						"+" + (int) ENERGY_DAMAGE_PERCENT + "%"
				);
			}
			info.addPara(indent + "Full bonus damage at %s range and below, " +
					   "no bonus damage at %s range and above",
					0f, tc, hc, 
					"" + (int) MIN_RANGE,
					"" + (int) MAX_RANGE
					);
		}
		
		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}
	}
	
	public static class Level2 implements ShipSkillEffect {
		public void apply(MutableShipStatsAPI stats, HullSize hullSize, String id, float level) {
			stats.getEnergyWeaponFluxCostMod().modifyMult(id, FLUX_COST_MULT);
		}
		
		public void unapply(MutableShipStatsAPI stats, HullSize hullSize, String id) {
			stats.getEnergyWeaponFluxCostMod().unmodify(id);
		}
		
		public String getEffectDescription(float level) {
			return "-" + (int)Math.round((1f - FLUX_COST_MULT) * 100f) + "% flux generated by energy weapons";
		}
		
		public String getEffectPerLevelDescription() {
			return null;
		}
		
		public ScopeDescription getScopeDescription() {
			return ScopeDescription.PILOTED_SHIP;
		}

	}

	public static Object DAM_BONUS_STATUS_KEY = new Object();
	
	public static class EWMDamageDealtMod implements DamageDealtModifier, AdvanceableListener {
		protected ShipAPI ship;
		public EWMDamageDealtMod(ShipAPI ship) {
			this.ship = ship;
		}
		
		public void advance(float amount) {
			if (Global.getCurrentState() == GameState.COMBAT &&
					Global.getCombatEngine() != null && Global.getCombatEngine().getPlayerShip() == ship) {

				int damageBonus = (int) Math.round((ship.getFluxBasedEnergyWeaponDamageMultiplier() * 100f - 100f));
				if (damageBonus > 0) {
					Global.getCombatEngine().maintainStatusForPlayerShip(DAM_BONUS_STATUS_KEY,
							Global.getSettings().getSpriteName("ui", "icon_energy"),
							"Energy weapon mastery", 
							"+" + damageBonus + "% energy weapon damage", false);
				}
				
			}
		}

		public String modifyDamageDealt(Object param,
								   		CombatEntityAPI target, DamageAPI damage,
								   		Vector2f point, boolean shieldHit) {
			
			//if (param instanceof MissileAPI) return null;
			
			Vector2f from = null;
			WeaponAPI weapon = null;
			if (param instanceof DamagingProjectileAPI) {
				from = ((DamagingProjectileAPI)param).getSpawnLocation();
				weapon = ((DamagingProjectileAPI)param).getWeapon();
			} else if (param instanceof BeamAPI) {
				from = ((BeamAPI)param).getFrom();
				weapon = ((BeamAPI)param).getWeapon();
			} else {
				return null;
			}
			
			if (weapon == null || ship == null) return null;
			if (weapon.getSpec().getType() != WeaponType.ENERGY) return null;
			
			float mag = ship.getFluxBasedEnergyWeaponDamageMultiplier() - 1f;
			if (mag <= 0) return null;
			
			float dist = Misc.getDistance(from, point);
			float f = 1f;
			if (dist > MAX_RANGE) {
				f = 0f;
			} else if (dist > MIN_RANGE) {
				f = 1f - (dist - MIN_RANGE) / (MAX_RANGE - MIN_RANGE);
			}
			if (f < 0) f = 0;
			if (f > 1) f = 1;
			
//			Vector2f vel = new Vector2f();
//			if (target instanceof ShipAPI) {
//				vel.set(target.getVelocity());
//			}
			
			String id = "ewm_dam_mod";
			damage.getModifier().modifyPercent(id, (mag * f) * 100f);
			return id;
		}
	}
	
}











