#!/bin/bash

DIR="$( cd "$( dirname "$BASH_SOURCE[0]}" )" && pwd )"
echo $DIR  > /tmp/out.txt

cd "$DIR"
cd "../Resources/Java"

export JAVA_HOME=../../Home
"$JAVA_HOME/bin/java" \
    -Xdock:name="Starsector" \
    -Xdock:icon=../../Resources/s_icon128.icns \
    -Dapple.laf.useScreenMenuBar=false \
    -Dcom.apple.macos.useScreenMenuBar=false \
    -Dapple.awt.showGrowBox=false \
    -Dfile.encoding=UTF-8 \
    ${EXTRAARGS} \
	-noverify \
	-XX:+UnlockDiagnosticVMOptions \
	-XX:+UnlockExperimentalVMOptions \
	-XX:+ShowCodeDetailsInExceptionMessages \
	-XX:+ExtensiveErrorReports \
	-XX:+ShowMessageBoxOnError \
	-XX:+PrintCommandLineFlags \
	-XX:+TieredCompilation \
	-XX:-UseCondCardMark \
	-Xlog:async \
	-XX:+UseFastStosb \
	-XX:+AlwaysCompileLoopMethods \
	-XX:TieredStopAtLevel=4 \
	-XX:TrimNativeHeapInterval=60000 \
	-XX:UseAVX=3 \
	-XX:AVX3Threshold=0 \
	-XX:UseSSE=4 \
	-XX:+UseSSE42Intrinsics \
	-XX:+UseCompressedOops \
	-XX:+UseCompressedClassPointers \
	-XX:+UseFMA \
	-XX:+UseBMI1Instructions \
	-XX:+UseBMI2Instructions \
	-XX:+UseCLMUL \
	-XX:+UseFastUnorderedTimeStamps \
	-XX:+UseUnalignedLoadStores \
	-XX:+UseXMMForArrayCopy \
	-XX:+UseXMMForObjInit \
	-XX:+UseXmmI2D \
	-XX:+UseXmmI2F \
	-XX:+DisableExplicitGC \
	-XX:+AlwaysPreTouch \
	-XX:+ParallelRefProcEnabled \
	-XX:+UseShenandoahGC \
	-XX:ShenandoahGCMode=iu \
	-XX:ShenandoahGCHeuristics=compact \
	-XX:ShenandoahAllocationThreshold=85 \
	-XX:ShenandoahGuaranteedGCInterval=0 \
	-XX:+ZeroTLAB \
	-XX:+SegmentedCodeCache \
	-XX:+AlwaysAtomicAccesses \
	-XX:+UseStringDeduplication \
	-XX:-DontCompileHugeMethods \
	-XX:Tier0Delay=1 \
	-XX:+UseFPUForSpilling \
	-XX:+EnableVectorAggressiveReboxing \
	-XX:+EnableVectorReboxing \
	-XX:+EnableVectorSupport \
	-XX:-AlignVector \
	-XX:TieredOldPercentage=10000 \
	-XX:Tier0ProfilingStartPercentage=2000 \
	-XX:IncreaseFirstTierCompileThresholdAt=99 \
	-XX:InterpreterProfilePercentage=99 \
	-XX:+UseVectorCmov \
	-XX:+UseVectorStubs \
	-XX:ReferencesPerThread=0 \
	-XX:MaxGCPauseMillis=10 \
	-XX:-EnableThreadSMRStatistics \
	-XX:+UseUnalignedAccesses \
	-XX:PerMethodRecompilationCutoff=100000 \
	-XX:ProfileMaturityPercentage=100 \
	-XX:NmethodSweepActivity=1 \
	-XX:ThreadPriorityPolicy=1 \
	-XX:ReservedCodeCacheSize=256m \
	-XX:+PrintCodeCache \
	-XX:-UseDynamicNumberOfCompilerThreads \
	-XX:CompilerDirectivesFile=../../MacOS/compiler_directives.txt \
	-Djava.library.path=../../Resources/Java/native/macosx \
	-XX:-BytecodeVerificationLocal \
	-XX:-BytecodeVerificationRemote \
	-Djava.util.Arrays.useLegacyMergeSort=true \
	--enable-preview \
	--add-opens=java.base/sun.nio.ch=ALL-UNNAMED \
	--add-opens=java.base/java.nio=ALL-UNNAMED \
	--add-opens=java.base/java.nio.Buffer.UNSAFE=ALL-UNNAMED \
	--add-opens=java.base/java.util=ALL-UNNAMED \
	--add-opens=java.base/java.util.concurrent=ALL-UNNAMED \
	--add-opens=java.base/java.util.concurrent.locks=ALL-UNNAMED \
	--add-opens=java.base/jdk.internal.ref=ALL-UNNAMED \
	--add-opens=java.base/java.lang.reflect=ALL-UNNAMED \
	--add-opens=java.base/java.lang.ref=ALL-UNNAMED \
	--add-opens=java.base/java.text=ALL-UNNAMED \
	--add-opens=java.desktop/java.awt.font=ALL-UNNAMED \
	--add-opens=java.desktop/java.awt.Rectangle=ALL-UNNAMED \
	--add-opens=java.desktop/java.awt=ALL-UNNAMED \
	--add-exports=java.base/jdk.internal.ref=ALL-UNNAMED \
	--add-exports=java.base/jdk.internal.misc=ALL-UNNAMED \
	--add-exports=java.base/sun.nio.ch=ALL-UNNAMED \
    -Xms2048m \
    -Xmx2048m \
    -Xss4m \
	-Dcom.fs.starfarer.settings.paths.saves=../../../saves \
	-Dcom.fs.starfarer.settings.paths.screenshots=../../../screenshots \
	-Dcom.fs.starfarer.settings.paths.mods=../../../mods \
	-Dcom.fs.starfarer.settings.paths.logs=../../../logs \
	-Dcom.fs.starfarer.settings.osx=true \
	-cp ../../Resources/Java/AppleJavaExtensions.jar:../../Resources/Java/commons-compiler-jdk.jar:../../Resources/Java/commons-compiler.jar:../../Resources/Java/fs.sound_obf.jar:../../Resources/Java/janino.jar:../../Resources/Java/jinput.jar:../../Resources/Java/jogg-0.0.7.jar:../../Resources/Java/jorbis-0.0.15.jar:../../Resources/Java/json.jar:../../Resources/Java/log4j-1.2.9.jar:../../Resources/Java/lwjgl.jar:../../Resources/Java/lwjgl_util.jar:../../Resources/Java/starfarer.api.jar:../../Resources/Java/starfarer_obf.jar:../../Resources/Java/fs.common_obf.jar:../../Resources/Java/xstream-1.4.10.jar:../../Resources/Java/txw2-3.0.2.jar:../../Resources/Java/jaxb-api-2.4.0-b180830.0359.jar:../../Resources/Java/webp-imageio-0.1.6.jar \
    com.fs.starfarer.StarfarerLauncher \
    "$@"

exit 0
