const remap = (value, low1, high1, low2, high2) => {
  return low2 + (value - low1) * (high2 - low2) / (high1 - low1);
}

const vid = document.getElementById("video");
const vid_rev = document.getElementById("rev-video");

const sources = ["pig.mp4", "wall.mp4", "bottle.mp4"]
var srcI = 0;

document.addEventListener('keydown', (e) => {
  if (e.keyCode == 9) { // Tab
    srcI = (srcI + 1)%sources.length;
    vid.src = sources[srcI];
    vid_rev.src = "rev-"+sources[srcI];
  }
});

// document.addEventListener('mousemove', (e) => {
//   var rect = e.target.getBoundingClientRect();
//   var x = e.x/rect.width;
//   var y = e.y/rect.height;

//   if (e.shiftKey) {
//     vid.currentTime = vid.duration*x;
//     console.log(vid.currentTime); 
//   }
//   if (e.altKey) {
//     vid.playbackRate = (1/16.)*Math.pow(16., 2.*x);
//     console.log(vid.playbackRate); 
//   }
// });

window.addEventListener('unity-loaded', (e) => {
  vid.play();
  vid_rev.play();
  showReverseVid(false);
});

const showReverseVid = (show) => {
  vid.style.display = !show ? "block" : "none";
  vid_rev.style.display = show ? "block" : "none";
}

const state = {};

const xMin = 0.5;
const xMax = 4.95;
const yExtent = 0.258;

var currentVid = vid;
var otherVid = vid_rev;

const setPlayTime = (time) => {
  if (isFinite(time)) {
    vid.currentTime = time;
    // vid_rev.currentTime = vid_rev.duration - time;
    if (currentVid.paused) {
      currentVid.play();
    }
  }
}

const syncVids = () => {
  const targetTime = currentVid.duration - currentVid.currentTime;;
  if (isFinite(targetTime)) {
    otherVid.currentTime = targetTime;
  }
}

const setPlaybackRate = (rate) => {
  syncVids();
  showReverseVid(rate < 0);
  const prevVid = currentVid;
  currentVid = (rate > 0) ? vid : vid_rev;
  otherVid = (rate > 0) ? vid_rev : vid;

  const arate = Math.abs(rate);
  if (isFinite(arate) && arate > 0.0625 && arate < 16) {
    currentVid.playbackRate = arate;
    if (prevVid != currentVid) {
      console.log("Flip");
      if (currentVid.paused) {
        currentVid.play();
      }
    }
  }
}

const updateRate = () => {
  const t2 = state.angle;
  const p2 = Math.sin(t2);
  const targetRate = remap(
    p2,
    -1.0, 1.0,
    -1.0, 1.0
  );
  // console.log(p2);
  setPlaybackRate(p2);
}
const updateTime = () => {
  const t1 = Math.atan2(state.y, state.x);
  const p1 = Math.sin(t1);
  const targetTime = remap(
    state.x,
    xMin, xMax,
    0.0, vid.duration
  );
  setPlayTime(targetTime);
}

window.footTrigger = (left) => {
  // console.log(left)
  if (state != {}) {
    updateTime();
  }
}

window.setState = (x, y, angle) => {
  state.x = x;
  state.y = y;
  state.angle = angle*Math.PI/180;
  // console.log(state);
  // updateRate();
}